
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1171.C - Message 1171 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1171 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

// Global data for dr parameters
extern tUSHORT DRSpeedSigma;    //standard deviation
extern tUSHORT DRSpeedTimeTag;  //resolution
extern tUSHORT DRSpeedLatency;


////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1171 message from the ZMsgBuf.
//
void Dec1171(tMSGBUF *ZMsgBuf, tMSG1171 *Msg)
{                                            
   // perform special decoding to unpack words
   GetBit(&Bits1171.BackUpStatus,            ZMsgBuf, 11, 0);  // 1=backing

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1171 message in the ZMsgBuf. 
//
void Bld1171(tMSGBUF *ZMsgBuf, tMSG1171 *Msg)
{

}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1171 message from the ZMsgBuf.
//
void Show1171(tMSG1171 *Msg)
{
   char    Buf[80] = "";
   char    BackupStatus[2];        
   float   TimeTag;

   // dr validity flags  
   strcpy(BackupStatus, " ");
   if(Bits1171.BackUpStatus) BackupStatus[0] = 'B';
   
   // calculate time tag using global resolution
   TimeTag = (float)(Msg->DRSpeedTimeTag * (DRSpeedTimeTag/100.0));
   
   // output the data items   
   sprintf(Buf,"%05d"   ,Msg->SequenceNumber );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%2s"    ,BackupStatus        );ShowText(Buf,DRFR   ,DRFC+ 7);
   sprintf(Buf,"%06.02f",Msg->DRSpeed/100.0  );ShowText(Buf,DRSR   ,DRSC+ 5);
   sprintf(Buf,"%06.02f",TimeTag             );ShowText(Buf,DRSR+ 1,DRSC+ 5);
}                                                   
                                      
                                           
